
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.DoneableClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkList;
import io.fabric8.openshift.api.model.DoneableClusterNetwork;

import java.util.Map;
import java.util.TreeMap;


public class ClusterNetworkOperationsImpl extends OpenShiftOperation<ClusterNetwork, ClusterNetworkList, DoneableClusterNetwork, Resource<ClusterNetwork, DoneableClusterNetwork>> {

  public ClusterNetworkOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ClusterNetworkOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("network.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("clusternetworks"));
    this.type = ClusterNetwork.class;
    this.listType = ClusterNetworkList.class;
    this.doneableType = DoneableClusterNetwork.class;
  }

  public ClusterNetworkOperationsImpl newInstance(OperationContext context) {
    return new ClusterNetworkOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
