
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.DoneableConsoleExternalLogLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkList;
import io.fabric8.openshift.api.model.console.v1.DoneableConsoleExternalLogLink;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleExternalLogLinkOperationsImpl extends OpenShiftOperation<ConsoleExternalLogLink, ConsoleExternalLogLinkList, DoneableConsoleExternalLogLink, Resource<ConsoleExternalLogLink, DoneableConsoleExternalLogLink>> {

  public ConsoleExternalLogLinkOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleExternalLogLinkOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consoleexternalloglinks"));
    this.type = ConsoleExternalLogLink.class;
    this.listType = ConsoleExternalLogLinkList.class;
    this.doneableType = DoneableConsoleExternalLogLink.class;
  }

  public ConsoleExternalLogLinkOperationsImpl newInstance(OperationContext context) {
    return new ConsoleExternalLogLinkOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
