
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.DoneableNetwork;
import io.fabric8.openshift.api.model.operator.v1.Network;
import io.fabric8.openshift.api.model.operator.v1.NetworkList;
import io.fabric8.openshift.api.model.operator.v1.DoneableNetwork;

import java.util.Map;
import java.util.TreeMap;


public class NetworkOperationsImpl extends OpenShiftOperation<Network, NetworkList, DoneableNetwork, Resource<Network, DoneableNetwork>> {

  public NetworkOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public NetworkOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("networks"));
    this.type = Network.class;
    this.listType = NetworkList.class;
    this.doneableType = DoneableNetwork.class;
  }

  public NetworkOperationsImpl newInstance(OperationContext context) {
    return new NetworkOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
