
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.DoneableOpenShiftAPIServer;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.DoneableOpenShiftAPIServer;

import java.util.Map;
import java.util.TreeMap;


public class OpenShiftAPIServerOperationsImpl extends OpenShiftOperation<OpenShiftAPIServer, OpenShiftAPIServerList, DoneableOpenShiftAPIServer, Resource<OpenShiftAPIServer, DoneableOpenShiftAPIServer>> {

  public OpenShiftAPIServerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OpenShiftAPIServerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("openshiftapiservers"));
    this.type = OpenShiftAPIServer.class;
    this.listType = OpenShiftAPIServerList.class;
    this.doneableType = DoneableOpenShiftAPIServer.class;
  }

  public OpenShiftAPIServerOperationsImpl newInstance(OperationContext context) {
    return new OpenShiftAPIServerOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
