
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.DoneableConsoleYAMLSample;
import io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSample;
import io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleList;
import io.fabric8.openshift.api.model.console.v1.DoneableConsoleYAMLSample;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleYAMLSampleOperationsImpl extends OpenShiftOperation<ConsoleYAMLSample, ConsoleYAMLSampleList, DoneableConsoleYAMLSample, Resource<ConsoleYAMLSample, DoneableConsoleYAMLSample>> {

  public ConsoleYAMLSampleOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleYAMLSampleOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consoleyamlsamples"));
    this.type = ConsoleYAMLSample.class;
    this.listType = ConsoleYAMLSampleList.class;
    this.doneableType = DoneableConsoleYAMLSample.class;
  }

  public ConsoleYAMLSampleOperationsImpl newInstance(OperationContext context) {
    return new ConsoleYAMLSampleOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
