
                
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.DoneableImageTag;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagList;
import io.fabric8.openshift.api.model.DoneableImageTag;

import java.util.Map;
import java.util.TreeMap;


public class ImageTagOperationsImpl extends OpenShiftOperation<ImageTag, ImageTagList, DoneableImageTag, Resource<ImageTag, DoneableImageTag>> {

  public ImageTagOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ImageTagOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("image.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("imagetags"));
    this.type = ImageTag.class;
    this.listType = ImageTagList.class;
    this.doneableType = DoneableImageTag.class;
  }

  public ImageTagOperationsImpl newInstance(OperationContext context) {
    return new ImageTagOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
