
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.DoneableProxy;
import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyList;
import io.fabric8.openshift.api.model.DoneableProxy;

import java.util.Map;
import java.util.TreeMap;


public class ProxyOperationsImpl extends OpenShiftOperation<Proxy, ProxyList, DoneableProxy, Resource<Proxy, DoneableProxy>> {

  public ProxyOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ProxyOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("config.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("proxies"));
    this.type = Proxy.class;
    this.listType = ProxyList.class;
    this.doneableType = DoneableProxy.class;
  }

  public ProxyOperationsImpl newInstance(OperationContext context) {
    return new ProxyOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
