
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.FeatureGateOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.FeatureGate;
import io.fabric8.openshift.api.model.FeatureGateBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class FeatureGateHandler implements ResourceHandler<FeatureGate, FeatureGateBuilder> {

  @Override
  public String getKind() {
    return FeatureGate.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public FeatureGate create(OkHttpClient client, Config config, String namespace, FeatureGate item) {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public FeatureGate replace(OkHttpClient client, Config config, String namespace, FeatureGate item) {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public FeatureGate reload(OkHttpClient client, Config config, String namespace, FeatureGate item) {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public FeatureGateBuilder edit(FeatureGate item) {
    return new FeatureGateBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, FeatureGate item) {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, FeatureGate item, Watcher<FeatureGate> watcher) {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, FeatureGate item, String resourceVersion, Watcher<FeatureGate> watcher) {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, FeatureGate item, ListOptions options, Watcher<FeatureGate> watcher) {
  return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public FeatureGate waitUntilReady(OkHttpClient client, Config config, String namespace, FeatureGate item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public FeatureGate waitUntilCondition(OkHttpClient client, Config config, String namespace, FeatureGate item, Predicate<FeatureGate> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new FeatureGateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
