
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.OperatorGroupOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OperatorGroupHandler implements ResourceHandler<OperatorGroup, OperatorGroupBuilder> {

  @Override
  public String getKind() {
    return OperatorGroup.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1";
    }

  @Override
  public OperatorGroup create(OkHttpClient client, Config config, String namespace, OperatorGroup item) {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public OperatorGroup replace(OkHttpClient client, Config config, String namespace, OperatorGroup item) {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public OperatorGroup reload(OkHttpClient client, Config config, String namespace, OperatorGroup item) {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OperatorGroupBuilder edit(OperatorGroup item) {
    return new OperatorGroupBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, OperatorGroup item) {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorGroup item, Watcher<OperatorGroup> watcher) {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorGroup item, String resourceVersion, Watcher<OperatorGroup> watcher) {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorGroup item, ListOptions options, Watcher<OperatorGroup> watcher) {
  return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public OperatorGroup waitUntilReady(OkHttpClient client, Config config, String namespace, OperatorGroup item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OperatorGroup waitUntilCondition(OkHttpClient client, Config config, String namespace, OperatorGroup item, Predicate<OperatorGroup> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorGroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
