/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operator.v1.Console;
import io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ConsoleOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ConsoleHandler
implements ResourceHandler<Console, ConsoleBuilder> {
    public String getKind() {
        return Console.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    public Console create(OkHttpClient client, Config config, String namespace, Console item) {
        return (Console)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new Console[0]);
    }

    public Console replace(OkHttpClient client, Config config, String namespace, Console item) {
        return (Console)((Resource)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public Console reload(OkHttpClient client, Config config, String namespace, Console item) {
        return (Console)((Gettable)((Resource)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ConsoleBuilder edit(Console item) {
        return new ConsoleBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Console item) {
        return (Boolean)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Console item, Watcher<Console> watcher) {
        return (Watch)((Resource)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Console item, String resourceVersion, Watcher<Console> watcher) {
        return (Watch)((Resource)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Console item, ListOptions options, Watcher<Console> watcher) {
        return (Watch)((Resource)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Console waitUntilReady(OkHttpClient client, Config config, String namespace, Console item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Console)((Resource)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Console waitUntilCondition(OkHttpClient client, Config config, String namespace, Console item, Predicate<Console> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Console)((Resource)new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

