
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.DoneableServiceCatalogAPIServer;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.DoneableServiceCatalogAPIServer;

import java.util.Map;
import java.util.TreeMap;


public class ServiceCatalogAPIServerOperationsImpl extends OpenShiftOperation<ServiceCatalogAPIServer, ServiceCatalogAPIServerList, DoneableServiceCatalogAPIServer, Resource<ServiceCatalogAPIServer, DoneableServiceCatalogAPIServer>> {

  public ServiceCatalogAPIServerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ServiceCatalogAPIServerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("servicecatalogapiservers"));
    this.type = ServiceCatalogAPIServer.class;
    this.listType = ServiceCatalogAPIServerList.class;
    this.doneableType = DoneableServiceCatalogAPIServer.class;
  }

  public ServiceCatalogAPIServerOperationsImpl newInstance(OperationContext context) {
    return new ServiceCatalogAPIServerOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
