
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ProxyOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ProxyHandler implements ResourceHandler<Proxy, ProxyBuilder> {

  @Override
  public String getKind() {
    return Proxy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public Proxy create(OkHttpClient client, Config config, String namespace, Proxy item) {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Proxy replace(OkHttpClient client, Config config, String namespace, Proxy item) {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Proxy reload(OkHttpClient client, Config config, String namespace, Proxy item) {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ProxyBuilder edit(Proxy item) {
    return new ProxyBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Proxy item) {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, Watcher<Proxy> watcher) {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, String resourceVersion, Watcher<Proxy> watcher) {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, ListOptions options, Watcher<Proxy> watcher) {
  return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Proxy waitUntilReady(OkHttpClient client, Config config, String namespace, Proxy item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Proxy waitUntilCondition(OkHttpClient client, Config config, String namespace, Proxy item, Predicate<Proxy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
