
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.DoneableConsoleNotification;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotification;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList;
import io.fabric8.openshift.api.model.console.v1.DoneableConsoleNotification;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleNotificationOperationsImpl extends OpenShiftOperation<ConsoleNotification, ConsoleNotificationList, DoneableConsoleNotification, Resource<ConsoleNotification, DoneableConsoleNotification>> {

  public ConsoleNotificationOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleNotificationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consolenotifications"));
    this.type = ConsoleNotification.class;
    this.listType = ConsoleNotificationList.class;
    this.doneableType = DoneableConsoleNotification.class;
  }

  public ConsoleNotificationOperationsImpl newInstance(OperationContext context) {
    return new ConsoleNotificationOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
