  
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.OAuthClientAuthorizationOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OAuthClientAuthorizationHandler implements ResourceHandler<OAuthClientAuthorization, OAuthClientAuthorizationBuilder> {

  @Override
  public String getKind() {
    return OAuthClientAuthorization.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public OAuthClientAuthorization create(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public OAuthClientAuthorization replace(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public OAuthClientAuthorization reload(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OAuthClientAuthorizationBuilder edit(OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, OAuthClientAuthorization item) {
    if (cascading) {
      return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
    } else {
      return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item, Watcher<OAuthClientAuthorization> watcher) {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item, String resourceVersion, Watcher<OAuthClientAuthorization> watcher) {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public OAuthClientAuthorization waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OAuthClientAuthorization waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item, Predicate<OAuthClientAuthorization> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
