
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

              

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.DoneableOAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.DoneableOAuthClientAuthorization;

import java.util.Map;
import java.util.TreeMap;


public class OAuthClientAuthorizationOperationsImpl extends OpenShiftOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, DoneableOAuthClientAuthorization, Resource<OAuthClientAuthorization, DoneableOAuthClientAuthorization>> {

  public OAuthClientAuthorizationOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public OAuthClientAuthorizationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("oauth.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("oauthclientauthorizations"));
    this.type = OAuthClientAuthorization.class;
    this.listType = OAuthClientAuthorizationList.class;
    this.doneableType = DoneableOAuthClientAuthorization.class;
  }

  public OAuthClientAuthorizationOperationsImpl newInstance(OperationContext context) {
    return new OAuthClientAuthorizationOperationsImpl(context);
  }
}
