
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyList;

import java.util.Map;
import java.util.TreeMap;


public class ImageContentSourcePolicyOperationsImpl extends OpenShiftOperation<ImageContentSourcePolicy, ImageContentSourcePolicyList, Resource<ImageContentSourcePolicy>> {

  public ImageContentSourcePolicyOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ImageContentSourcePolicyOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1alpha1")
    .withPlural("imagecontentsourcepolicies"));
    this.type = ImageContentSourcePolicy.class;
    this.listType = ImageContentSourcePolicyList.class;
  }

  public ImageContentSourcePolicyOperationsImpl newInstance(OperationContext context) {
    return new ImageContentSourcePolicyOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
