
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.KubeScheduler;
import io.fabric8.openshift.api.model.operator.v1.KubeSchedulerList;

import java.util.Map;
import java.util.TreeMap;


public class KubeSchedulerOperationsImpl extends OpenShiftOperation<KubeScheduler, KubeSchedulerList, Resource<KubeScheduler>> {

  public KubeSchedulerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KubeSchedulerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("kubeschedulers"));
    this.type = KubeScheduler.class;
    this.listType = KubeSchedulerList.class;
  }

  public KubeSchedulerOperationsImpl newInstance(OperationContext context) {
    return new KubeSchedulerOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
