
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ServiceCatalogControllerManagerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ServiceCatalogControllerManagerHandler implements ResourceHandler<ServiceCatalogControllerManager, ServiceCatalogControllerManagerBuilder> {

  @Override
  public String getKind() {
    return ServiceCatalogControllerManager.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public ServiceCatalogControllerManager create(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ServiceCatalogControllerManager replace(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ServiceCatalogControllerManager reload(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ServiceCatalogControllerManagerBuilder edit(ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item, Watcher<ServiceCatalogControllerManager> watcher) {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item, String resourceVersion, Watcher<ServiceCatalogControllerManager> watcher) {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item, ListOptions options, Watcher<ServiceCatalogControllerManager> watcher) {
  return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ServiceCatalogControllerManager waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ServiceCatalogControllerManager waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item, Predicate<ServiceCatalogControllerManager> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
