
                
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageList;

import java.util.Map;
import java.util.TreeMap;


public class ImageOperationsImpl extends OpenShiftOperation<Image, ImageList, Resource<Image>> {

  public ImageOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ImageOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("image.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("images"));
    this.type = Image.class;
    this.listType = ImageList.class;
  }

  public ImageOperationsImpl newInstance(OperationContext context) {
    return new ImageOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
