
                
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.PodMonitor;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList;

import java.util.Map;
import java.util.TreeMap;


public class PodMonitorOperationsImpl extends OpenShiftOperation<PodMonitor, PodMonitorList, Resource<PodMonitor>> {

  public PodMonitorOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PodMonitorOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("monitoring.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("podmonitors"));
    this.type = PodMonitor.class;
    this.listType = PodMonitorList.class;
  }

  public PodMonitorOperationsImpl newInstance(OperationContext context) {
    return new PodMonitorOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
