
                
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;

import java.util.Map;
import java.util.TreeMap;


public class RouteOperationsImpl extends OpenShiftOperation<Route, RouteList, Resource<Route>> {

  public RouteOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public RouteOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("route.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("routes"));
    this.type = Route.class;
    this.listType = RouteList.class;
  }

  public RouteOperationsImpl newInstance(OperationContext context) {
    return new RouteOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
