
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.CatalogSourceOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CatalogSourceHandler implements ResourceHandler<CatalogSource, CatalogSourceBuilder> {

  @Override
  public String getKind() {
    return CatalogSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1alpha1";
    }

  @Override
  public CatalogSource create(OkHttpClient client, Config config, String namespace, CatalogSource item) {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public CatalogSource replace(OkHttpClient client, Config config, String namespace, CatalogSource item) {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public CatalogSource reload(OkHttpClient client, Config config, String namespace, CatalogSource item) {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CatalogSourceBuilder edit(CatalogSource item) {
    return new CatalogSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, CatalogSource item) {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CatalogSource item, Watcher<CatalogSource> watcher) {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CatalogSource item, String resourceVersion, Watcher<CatalogSource> watcher) {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CatalogSource item, ListOptions options, Watcher<CatalogSource> watcher) {
  return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public CatalogSource waitUntilReady(OkHttpClient client, Config config, String namespace, CatalogSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CatalogSource waitUntilCondition(OkHttpClient client, Config config, String namespace, CatalogSource item, Predicate<CatalogSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
