
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.DNSRecordOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.DNSRecord;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class DNSRecordHandler implements ResourceHandler<DNSRecord, DNSRecordBuilder> {

  @Override
  public String getKind() {
    return DNSRecord.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "ingress.operator.openshift.io/v1";
    }

  @Override
  public DNSRecord create(OkHttpClient client, Config config, String namespace, DNSRecord item) {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public DNSRecord replace(OkHttpClient client, Config config, String namespace, DNSRecord item) {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public DNSRecord reload(OkHttpClient client, Config config, String namespace, DNSRecord item) {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public DNSRecordBuilder edit(DNSRecord item) {
    return new DNSRecordBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, DNSRecord item) {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, DNSRecord item, Watcher<DNSRecord> watcher) {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, DNSRecord item, String resourceVersion, Watcher<DNSRecord> watcher) {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, DNSRecord item, ListOptions options, Watcher<DNSRecord> watcher) {
  return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public DNSRecord waitUntilReady(OkHttpClient client, Config config, String namespace, DNSRecord item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public DNSRecord waitUntilCondition(OkHttpClient client, Config config, String namespace, DNSRecord item, Predicate<DNSRecord> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
