
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.APIServer;
import io.fabric8.openshift.api.model.APIServerBuilder;
import io.fabric8.openshift.api.model.APIServerList;

import java.util.Map;
import java.util.TreeMap;


public class APIServerOperationsImpl extends OpenShiftOperation<APIServer, APIServerList, Resource<APIServer>> {

  public APIServerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public APIServerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("config.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("apiservers"));
    this.type = APIServer.class;
    this.listType = APIServerList.class;
  }

  public APIServerOperationsImpl newInstance(OperationContext context) {
    return new APIServerOperationsImpl(context);
  }

  @Override
  public APIServer edit(Visitor... visitors) {
    return patch(new APIServerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
