
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkBuilder;
import io.fabric8.openshift.api.model.ClusterNetworkList;

import java.util.Map;
import java.util.TreeMap;


public class ClusterNetworkOperationsImpl extends OpenShiftOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> {

  public ClusterNetworkOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ClusterNetworkOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("network.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("clusternetworks"));
    this.type = ClusterNetwork.class;
    this.listType = ClusterNetworkList.class;
  }

  public ClusterNetworkOperationsImpl newInstance(OperationContext context) {
    return new ClusterNetworkOperationsImpl(context);
  }

  @Override
  public ClusterNetwork edit(Visitor... visitors) {
    return patch(new ClusterNetworkBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
