
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.ClusterResourceQuota;
import io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder;
import io.fabric8.openshift.api.model.ClusterResourceQuotaList;

import java.util.Map;
import java.util.TreeMap;


public class ClusterResourceQuotaOperationsImpl extends OpenShiftOperation<ClusterResourceQuota, ClusterResourceQuotaList, Resource<ClusterResourceQuota>> {

  public ClusterResourceQuotaOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ClusterResourceQuotaOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("quota.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("clusterresourcequotas"));
    this.type = ClusterResourceQuota.class;
    this.listType = ClusterResourceQuotaList.class;
  }

  public ClusterResourceQuotaOperationsImpl newInstance(OperationContext context) {
    return new ClusterResourceQuotaOperationsImpl(context);
  }

  @Override
  public ClusterResourceQuota edit(Visitor... visitors) {
    return patch(new ClusterResourceQuotaBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
