
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkList;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleExternalLogLinkOperationsImpl extends OpenShiftOperation<ConsoleExternalLogLink, ConsoleExternalLogLinkList, Resource<ConsoleExternalLogLink>> {

  public ConsoleExternalLogLinkOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleExternalLogLinkOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consoleexternalloglinks"));
    this.type = ConsoleExternalLogLink.class;
    this.listType = ConsoleExternalLogLinkList.class;
  }

  public ConsoleExternalLogLinkOperationsImpl newInstance(OperationContext context) {
    return new ConsoleExternalLogLinkOperationsImpl(context);
  }

  @Override
  public ConsoleExternalLogLink edit(Visitor... visitors) {
    return patch(new ConsoleExternalLogLinkBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
