
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleLinkBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleLinkList;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleLinkOperationsImpl extends OpenShiftOperation<ConsoleLink, ConsoleLinkList, Resource<ConsoleLink>> {

  public ConsoleLinkOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleLinkOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consolelinks"));
    this.type = ConsoleLink.class;
    this.listType = ConsoleLinkList.class;
  }

  public ConsoleLinkOperationsImpl newInstance(OperationContext context) {
    return new ConsoleLinkOperationsImpl(context);
  }

  @Override
  public ConsoleLink edit(Visitor... visitors) {
    return patch(new ConsoleLinkBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
