
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleNotification;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleNotificationOperationsImpl extends OpenShiftOperation<ConsoleNotification, ConsoleNotificationList, Resource<ConsoleNotification>> {

  public ConsoleNotificationOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleNotificationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consolenotifications"));
    this.type = ConsoleNotification.class;
    this.listType = ConsoleNotificationList.class;
  }

  public ConsoleNotificationOperationsImpl newInstance(OperationContext context) {
    return new ConsoleNotificationOperationsImpl(context);
  }

  @Override
  public ConsoleNotification edit(Visitor... visitors) {
    return patch(new ConsoleNotificationBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
