
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.Etcd;
import io.fabric8.openshift.api.model.operator.v1.EtcdBuilder;
import io.fabric8.openshift.api.model.operator.v1.EtcdList;

import java.util.Map;
import java.util.TreeMap;


public class EtcdOperationsImpl extends OpenShiftOperation<Etcd, EtcdList, Resource<Etcd>> {

  public EtcdOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public EtcdOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("etcds"));
    this.type = Etcd.class;
    this.listType = EtcdList.class;
  }

  public EtcdOperationsImpl newInstance(OperationContext context) {
    return new EtcdOperationsImpl(context);
  }

  @Override
  public Etcd edit(Visitor... visitors) {
    return patch(new EtcdBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
