
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator;
import io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder;
import io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorList;

import java.util.Map;
import java.util.TreeMap;


public class KubeStorageVersionMigratorOperationsImpl extends OpenShiftOperation<KubeStorageVersionMigrator, KubeStorageVersionMigratorList, Resource<KubeStorageVersionMigrator>> {

  public KubeStorageVersionMigratorOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KubeStorageVersionMigratorOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("kubestorageversionmigrators"));
    this.type = KubeStorageVersionMigrator.class;
    this.listType = KubeStorageVersionMigratorList.class;
  }

  public KubeStorageVersionMigratorOperationsImpl newInstance(OperationContext context) {
    return new KubeStorageVersionMigratorOperationsImpl(context);
  }

  @Override
  public KubeStorageVersionMigrator edit(Visitor... visitors) {
    return patch(new KubeStorageVersionMigratorBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
