
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceBuilder;
import io.fabric8.openshift.api.model.NetNamespaceList;

import java.util.Map;
import java.util.TreeMap;


public class NetNamespaceOperationsImpl extends OpenShiftOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> {

  public NetNamespaceOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public NetNamespaceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("network.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("netnamespaces"));
    this.type = NetNamespace.class;
    this.listType = NetNamespaceList.class;
  }

  public NetNamespaceOperationsImpl newInstance(OperationContext context) {
    return new NetNamespaceOperationsImpl(context);
  }

  @Override
  public NetNamespace edit(Visitor... visitors) {
    return patch(new NetNamespaceBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
