
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OAuth;
import io.fabric8.openshift.api.model.OAuthBuilder;
import io.fabric8.openshift.api.model.OAuthList;

import java.util.Map;
import java.util.TreeMap;


public class OAuthOperationsImpl extends OpenShiftOperation<OAuth, OAuthList, Resource<OAuth>> {

  public OAuthOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OAuthOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("config.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("oauths"));
    this.type = OAuth.class;
    this.listType = OAuthList.class;
  }

  public OAuthOperationsImpl newInstance(OperationContext context) {
    return new OAuthOperationsImpl(context);
  }

  @Override
  public OAuth edit(Visitor... visitors) {
    return patch(new OAuthBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
