
                
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupList;

import java.util.Map;
import java.util.TreeMap;


public class OperatorGroupOperationsImpl extends OpenShiftOperation<OperatorGroup, OperatorGroupList, Resource<OperatorGroup>> {

  public OperatorGroupOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OperatorGroupOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operators.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("operatorgroups"));
    this.type = OperatorGroup.class;
    this.listType = OperatorGroupList.class;
  }

  public OperatorGroupOperationsImpl newInstance(OperationContext context) {
    return new OperatorGroupOperationsImpl(context);
  }

  @Override
  public OperatorGroup edit(Visitor... visitors) {
    return patch(new OperatorGroupBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
