
                
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.PrometheusRule;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleList;

import java.util.Map;
import java.util.TreeMap;


public class PrometheusRuleOperationsImpl extends OpenShiftOperation<PrometheusRule, PrometheusRuleList, Resource<PrometheusRule>> {

  public PrometheusRuleOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PrometheusRuleOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("monitoring.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("prometheusrules"));
    this.type = PrometheusRule.class;
    this.listType = PrometheusRuleList.class;
  }

  public PrometheusRuleOperationsImpl newInstance(OperationContext context) {
    return new PrometheusRuleOperationsImpl(context);
  }

  @Override
  public PrometheusRule edit(Visitor... visitors) {
    return patch(new PrometheusRuleBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
