
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.RangeAllocation;
import io.fabric8.openshift.api.model.RangeAllocationBuilder;
import io.fabric8.openshift.api.model.RangeAllocationList;

import java.util.Map;
import java.util.TreeMap;


public class RangeAllocationOperationsImpl extends OpenShiftOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> {

  public RangeAllocationOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public RangeAllocationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("security.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("rangeallocations"));
    this.type = RangeAllocation.class;
    this.listType = RangeAllocationList.class;
  }

  public RangeAllocationOperationsImpl newInstance(OperationContext context) {
    return new RangeAllocationOperationsImpl(context);
  }

  @Override
  public RangeAllocation edit(Visitor... visitors) {
    return patch(new RangeAllocationBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
