
                
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerList;

import java.util.Map;
import java.util.TreeMap;


public class ServiceCatalogAPIServerOperationsImpl extends OpenShiftOperation<ServiceCatalogAPIServer, ServiceCatalogAPIServerList, Resource<ServiceCatalogAPIServer>> {

  public ServiceCatalogAPIServerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ServiceCatalogAPIServerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("servicecatalogapiservers"));
    this.type = ServiceCatalogAPIServer.class;
    this.listType = ServiceCatalogAPIServerList.class;
  }

  public ServiceCatalogAPIServerOperationsImpl newInstance(OperationContext context) {
    return new ServiceCatalogAPIServerOperationsImpl(context);
  }

  @Override
  public ServiceCatalogAPIServer edit(Visitor... visitors) {
    return patch(new ServiceCatalogAPIServerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
