
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ClusterNetworkOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ClusterNetworkHandler implements ResourceHandler<ClusterNetwork, ClusterNetworkBuilder> {

  @Override
  public String getKind() {
    return ClusterNetwork.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.openshift.io/v1";
    }

  @Override
  public ClusterNetwork create(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ClusterNetwork replace(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ClusterNetwork reload(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ClusterNetworkBuilder edit(ClusterNetwork item) {
    return new ClusterNetworkBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterNetwork item) {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, Watcher<ClusterNetwork> watcher) {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, String resourceVersion, Watcher<ClusterNetwork> watcher) {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, ListOptions options, Watcher<ClusterNetwork> watcher) {
  return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ClusterNetwork waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterNetwork item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ClusterNetwork waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterNetwork item, Predicate<ClusterNetwork> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
