
                            
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder;
import io.fabric8.openshift.api.model.EgressNetworkPolicyList;

import java.util.Map;
import java.util.TreeMap;


public class EgressNetworkPolicyOperationsImpl extends OpenShiftOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> {

  public EgressNetworkPolicyOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public EgressNetworkPolicyOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("network.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("egressnetworkpolicies"));
    this.type = EgressNetworkPolicy.class;
    this.listType = EgressNetworkPolicyList.class;
  }

  public EgressNetworkPolicyOperationsImpl newInstance(OperationContext context) {
    return new EgressNetworkPolicyOperationsImpl(context);
  }

  @Override
  public EgressNetworkPolicy edit(Visitor... visitors) {
    return patch(new EgressNetworkPolicyBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
