
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.PodMonitorOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitor;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PodMonitorHandler implements ResourceHandler<PodMonitor, PodMonitorBuilder> {

  @Override
  public String getKind() {
    return PodMonitor.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "monitoring.coreos.com/v1";
    }

  @Override
  public PodMonitor create(OkHttpClient client, Config config, String namespace, PodMonitor item) {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public PodMonitor replace(OkHttpClient client, Config config, String namespace, PodMonitor item) {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public PodMonitor reload(OkHttpClient client, Config config, String namespace, PodMonitor item) {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PodMonitorBuilder edit(PodMonitor item) {
    return new PodMonitorBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, PodMonitor item) {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodMonitor item, Watcher<PodMonitor> watcher) {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodMonitor item, String resourceVersion, Watcher<PodMonitor> watcher) {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodMonitor item, ListOptions options, Watcher<PodMonitor> watcher) {
  return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public PodMonitor waitUntilReady(OkHttpClient client, Config config, String namespace, PodMonitor item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PodMonitor waitUntilCondition(OkHttpClient client, Config config, String namespace, PodMonitor item, Predicate<PodMonitor> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
