
                            
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityBuilder;
import io.fabric8.openshift.api.model.IdentityList;

import java.util.Map;
import java.util.TreeMap;


public class IdentityOperationsImpl extends OpenShiftOperation<Identity, IdentityList, Resource<Identity>> {

  public IdentityOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public IdentityOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("user.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("identities"));
    this.type = Identity.class;
    this.listType = IdentityList.class;
  }

  public IdentityOperationsImpl newInstance(OperationContext context) {
    return new IdentityOperationsImpl(context);
  }

  @Override
  public Identity edit(Visitor... visitors) {
    return patch(new IdentityBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
