
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.KubeAPIServerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServer;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class KubeAPIServerHandler implements ResourceHandler<KubeAPIServer, KubeAPIServerBuilder> {

  @Override
  public String getKind() {
    return KubeAPIServer.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public KubeAPIServer create(OkHttpClient client, Config config, String namespace, KubeAPIServer item) {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public KubeAPIServer replace(OkHttpClient client, Config config, String namespace, KubeAPIServer item) {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public KubeAPIServer reload(OkHttpClient client, Config config, String namespace, KubeAPIServer item) {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public KubeAPIServerBuilder edit(KubeAPIServer item) {
    return new KubeAPIServerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, KubeAPIServer item) {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KubeAPIServer item, Watcher<KubeAPIServer> watcher) {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KubeAPIServer item, String resourceVersion, Watcher<KubeAPIServer> watcher) {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KubeAPIServer item, ListOptions options, Watcher<KubeAPIServer> watcher) {
  return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public KubeAPIServer waitUntilReady(OkHttpClient client, Config config, String namespace, KubeAPIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public KubeAPIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, KubeAPIServer item, Predicate<KubeAPIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
