
                            
  

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerList;

import java.util.Map;
import java.util.TreeMap;


public class OpenShiftControllerManagerOperationsImpl extends OpenShiftOperation<OpenShiftControllerManager, OpenShiftControllerManagerList, Resource<OpenShiftControllerManager>> {

  public OpenShiftControllerManagerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OpenShiftControllerManagerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("openshiftcontrollermanagers"));
    this.type = OpenShiftControllerManager.class;
    this.listType = OpenShiftControllerManagerList.class;
  }

  public OpenShiftControllerManagerOperationsImpl newInstance(OperationContext context) {
    return new OpenShiftControllerManagerOperationsImpl(context);
  }

  @Override
  public OpenShiftControllerManager edit(Visitor... visitors) {
    return patch(new OpenShiftControllerManagerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
