
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ConsoleYAMLSampleOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSample;
import io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsoleYAMLSampleHandler implements ResourceHandler<ConsoleYAMLSample, ConsoleYAMLSampleBuilder> {

  @Override
  public String getKind() {
    return ConsoleYAMLSample.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleYAMLSample create(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item, boolean dryRun) {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ConsoleYAMLSample replace(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item, boolean dryRun) {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ConsoleYAMLSample reload(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item) {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsoleYAMLSampleBuilder edit(ConsoleYAMLSample item) {
    return new ConsoleYAMLSampleBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsoleYAMLSample item, boolean dryRun) {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item, Watcher<ConsoleYAMLSample> watcher) {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item, String resourceVersion, Watcher<ConsoleYAMLSample> watcher) {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item, ListOptions options, Watcher<ConsoleYAMLSample> watcher) {
  return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ConsoleYAMLSample waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ConsoleYAMLSample waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleYAMLSample item, Predicate<ConsoleYAMLSample> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleYAMLSampleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
