
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ImagePrunerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.ImagePruner;
import io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ImagePrunerHandler implements ResourceHandler<ImagePruner, ImagePrunerBuilder> {

  @Override
  public String getKind() {
    return ImagePruner.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "imageregistry.operator.openshift.io/v1";
    }

  @Override
  public ImagePruner create(OkHttpClient client, Config config, String namespace, ImagePruner item, boolean dryRun) {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ImagePruner replace(OkHttpClient client, Config config, String namespace, ImagePruner item, boolean dryRun) {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ImagePruner reload(OkHttpClient client, Config config, String namespace, ImagePruner item) {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ImagePrunerBuilder edit(ImagePruner item) {
    return new ImagePrunerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ImagePruner item, boolean dryRun) {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImagePruner item, Watcher<ImagePruner> watcher) {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImagePruner item, String resourceVersion, Watcher<ImagePruner> watcher) {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImagePruner item, ListOptions options, Watcher<ImagePruner> watcher) {
  return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ImagePruner waitUntilReady(OkHttpClient client, Config config, String namespace, ImagePruner item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ImagePruner waitUntilCondition(OkHttpClient client, Config config, String namespace, ImagePruner item, Predicate<ImagePruner> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
