
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.OAuthOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.OAuth;
import io.fabric8.openshift.api.model.OAuthBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OAuthHandler implements ResourceHandler<OAuth, OAuthBuilder> {

  @Override
  public String getKind() {
    return OAuth.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public OAuth create(OkHttpClient client, Config config, String namespace, OAuth item, boolean dryRun) {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public OAuth replace(OkHttpClient client, Config config, String namespace, OAuth item, boolean dryRun) {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public OAuth reload(OkHttpClient client, Config config, String namespace, OAuth item) {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OAuthBuilder edit(OAuth item) {
    return new OAuthBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OAuth item, boolean dryRun) {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, Watcher<OAuth> watcher) {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, String resourceVersion, Watcher<OAuth> watcher) {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, ListOptions options, Watcher<OAuth> watcher) {
  return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public OAuth waitUntilReady(OkHttpClient client, Config config, String namespace, OAuth item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OAuth waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuth item, Predicate<OAuth> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
