
                            
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.Prometheus;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusList;

import java.util.Map;
import java.util.TreeMap;


public class PrometheusOperationsImpl extends OpenShiftOperation<Prometheus, PrometheusList, Resource<Prometheus>> {

  public PrometheusOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PrometheusOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("monitoring.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("prometheus"));
    this.type = Prometheus.class;
    this.listType = PrometheusList.class;
  }

  public PrometheusOperationsImpl newInstance(OperationContext context) {
    return new PrometheusOperationsImpl(context);
  }

  @Override
  public Prometheus edit(Visitor... visitors) {
    return patch(new PrometheusBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
