
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.CSISnapshotControllerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.CSISnapshotController;
import io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CSISnapshotControllerHandler implements ResourceHandler<CSISnapshotController, CSISnapshotControllerBuilder> {

  @Override
  public String getKind() {
    return CSISnapshotController.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public CSISnapshotController create(OkHttpClient client, Config config, String namespace, CSISnapshotController item, boolean dryRun) {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public CSISnapshotController replace(OkHttpClient client, Config config, String namespace, CSISnapshotController item, boolean dryRun) {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public CSISnapshotController reload(OkHttpClient client, Config config, String namespace, CSISnapshotController item) {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CSISnapshotControllerBuilder edit(CSISnapshotController item) {
    return new CSISnapshotControllerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CSISnapshotController item, boolean dryRun) {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSISnapshotController item, Watcher<CSISnapshotController> watcher) {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSISnapshotController item, String resourceVersion, Watcher<CSISnapshotController> watcher) {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSISnapshotController item, ListOptions options, Watcher<CSISnapshotController> watcher) {
  return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public CSISnapshotController waitUntilReady(OkHttpClient client, Config config, String namespace, CSISnapshotController item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CSISnapshotController waitUntilCondition(OkHttpClient client, Config config, String namespace, CSISnapshotController item, Predicate<CSISnapshotController> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CSISnapshotControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
