package io.fabric8.openshift.client;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.client.Config;
import java.lang.String;
import io.sundr.builder.annotations.BuildableReference;
import io.fabric8.kubernetes.client.ConfigFluent;
import java.lang.Integer;
import okhttp3.TlsVersion;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface OpenShiftConfigFluent<A extends OpenShiftConfigFluent<A>> extends ConfigFluent<A> {


    public String getOapiVersion();
    public A withOapiVersion(String oapiVersion);
    public Boolean hasOapiVersion();
    public A withNewOapiVersion(StringBuilder arg1);
    public A withNewOapiVersion(int[] arg1,int arg2,int arg3);
    public A withNewOapiVersion(char[] arg1);
    public A withNewOapiVersion(StringBuffer arg1);
    public A withNewOapiVersion(byte[] arg1,int arg2);
    public A withNewOapiVersion(byte[] arg1);
    public A withNewOapiVersion(char[] arg1,int arg2,int arg3);
    public A withNewOapiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewOapiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewOapiVersion(String arg1);
    public String getOpenShiftUrl();
    public A withOpenShiftUrl(String openShiftUrl);
    public Boolean hasOpenShiftUrl();
    public A withNewOpenShiftUrl(StringBuilder arg1);
    public A withNewOpenShiftUrl(int[] arg1,int arg2,int arg3);
    public A withNewOpenShiftUrl(char[] arg1);
    public A withNewOpenShiftUrl(StringBuffer arg1);
    public A withNewOpenShiftUrl(byte[] arg1,int arg2);
    public A withNewOpenShiftUrl(byte[] arg1);
    public A withNewOpenShiftUrl(char[] arg1,int arg2,int arg3);
    public A withNewOpenShiftUrl(byte[] arg1,int arg2,int arg3);
    public A withNewOpenShiftUrl(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewOpenShiftUrl(String arg1);
    public long getBuildTimeout();
    public A withBuildTimeout(long buildTimeout);
    public Boolean hasBuildTimeout();
    public boolean isOpenshiftApiGroupsEnabled();
    public A withOpenshiftApiGroupsEnabled(boolean openshiftApiGroupsEnabled);
    public Boolean hasOpenshiftApiGroupsEnabled();
    public boolean isDisableApiGroupCheck();
    public A withDisableApiGroupCheck(boolean disableApiGroupCheck);
    public Boolean hasDisableApiGroupCheck();
}
