
                            
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlan;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanList;

import java.util.Map;
import java.util.TreeMap;


public class InstallPlanOperationsImpl extends OpenShiftOperation<InstallPlan, InstallPlanList, Resource<InstallPlan>> {

  public InstallPlanOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public InstallPlanOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operators.coreos.com")
    .withApiGroupVersion("v1alpha1")
    .withPlural("installplans"));
    this.type = InstallPlan.class;
    this.listType = InstallPlanList.class;
  }

  public InstallPlanOperationsImpl newInstance(OperationContext context) {
    return new InstallPlanOperationsImpl(context);
  }

  @Override
  public InstallPlan edit(Visitor... visitors) {
    return patch(new InstallPlanBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
